(function() {
  //    FILE:EventCollection
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 2/18/13
  //    Farmerswife SL.
  var indexOf = [].indexOf;

  define(['jquery', 'Backbone', 'Backbone.LocalStorage', 'moment', 'models/project/ProjectModel', 'models/request/RequestModel'], function($, Backbone, LocalStorage, Moment, ProjectModel, RequestModel) {
    var ProjectCollection;
    return ProjectCollection = (function() {
      class ProjectCollection extends Backbone.Collection {
        initialize() {
          return this.reqMdl = new RequestModel();
        }

        comparator(project) {
          return project.get('name');
        }

        get_projects(usr) {
          var jsonReq, response, that, xmlReq;
          $.mobile.loading('hide');
          jsonReq = this.reqMdl.get('JGetProjects');
          //timeStamp = usr.get('objectlist_updated_at')
          this.reqMdl.__setNodeValue(jsonReq, 'sessionID', usr.get('sessionID'));
          xmlReq = this.reqMdl.__getXML(jsonReq);
          that = this;
          response = this.reqMdl.__send_server_xmlrequest(xmlReq);
          response.done(function(data, textStatus, jqXHR) {
            var cfields, jsonObj, lSCFields;
            jsonObj = data;
            if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
              that.set(jsonObj.Result.Project);
              cfields = jsonObj.Result.CustomField;
              lSCFields = new LocalStorage('ProjectCFields');
              lSCFields.records = [];
              _.each(cfields, function(cf) {
                return lSCFields.records.push(JSON.stringify(cf));
              });
              lSCFields.save();
              return that.trigger('projectlist_updated');
            } else {
              if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
                window.localStorage.clear();
                return window.location.href = 'index.html?expired=1';
              }
            }
          }).fail(function(data, textStatus, jqXHR) {
            //console.log "ERROR #{textStatus} "+data
            return false;
          }).always(function(data, textStatus) {});
          return this;
        }

        get_recent_projects_ids(usr) {
          var jsonReq, response, that, xmlReq;
          jsonReq = this.reqMdl.get('JGetRecentProjectIDS');
          //timeStamp = usr.get('objectlist_updated_at')
          this.reqMdl.__setNodeValue(jsonReq, 'sessionID', usr.get('sessionID'));
          xmlReq = this.reqMdl.__getXML(jsonReq);
          that = this;
          response = this.reqMdl.__send_server_xmlrequest(xmlReq);
          response.done(function(data, textStatus, jqXHR) {
            var jsonObj, lS;
            jsonObj = data;
            if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
              lS = new LocalStorage('Projects_Recent_IDS');
              lS.records = _.pluck(jsonObj, 'id');
              lS.save();
              return that.trigger('projectlist_recent_updated');
            } else {
              if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
                window.localStorage.clear();
                return window.location.href = 'index.html?expired=1';
              }
            }
          }).fail(function(data, textStatus, jqXHR) {
            //console.log "ERROR #{textStatus} "+data
            return false;
          }).always(function(data, textStatus) {});
          return this;
        }

        get_recent_projects() {
          var projects, recentIDs;
          recentIDs = window.localStorage.getItem('Projects_Recent_IDS');
          projects = [];
          this.each(function(proj) {
            var ref;
            if (ref = proj != null ? proj.get('projectID') : void 0, indexOf.call(recentIDs, ref) >= 0) {
              return projects.push(proj);
            }
          });
          return projects;
        }

        findByNameOrCompanyOrNumber(q) {
          var query, res;
          res = [];
          query = q.toLowerCase();
          _.each(this.models, function(proj) {
            var error, name, ref, ref1, ref2, ref3, ref4;
            try {
              if (proj instanceof ProjectModel) {
                name = (ref = String(proj.get('name'))) != null ? ref.toLowerCase() : void 0;
                if ((proj != null ? (ref1 = proj.get('name')) != null ? (ref2 = ref1.toLowerCase()) != null ? ref2.indexOf(query) : void 0 : void 0 : void 0) !== -1) {
                  res.push(proj);
                }
                if ((proj != null ? (ref3 = proj.get('contactCompanyName')) != null ? (ref4 = ref3.toLowerCase()) != null ? ref4.indexOf(query) : void 0 : void 0 : void 0) !== -1) {
                  res.push(proj);
                }
                if (String(proj != null ? proj.get('number') : void 0) === query) {
                  return res.push(proj);
                }
              }
            } catch (error1) {
              error = error1;
            }
          });
          //console.log(error)
          return new ProjectCollection(res);
        }

      };

      ProjectCollection.prototype.model = ProjectModel;

      ProjectCollection.prototype.localStorage = new LocalStorage('Projects');

      return ProjectCollection;

    }).call(this);
  });

}).call(this);
